/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: AP_Sfl.h 1892 2014-10-08 06:50:54Z stephans $:

  Description:
    USER - Headerfile of Serial FLASH Module

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2014-09-18  Drv_SflInfoFlash() added to retrieve flash information
    2011-03-14  Removed non-implemented function prototypes
    2010-03-23  File created.

**************************************************************************************/


#ifdef __cplusplus
extern "C" {
#endif


#ifndef __AP_SFL_H
  #define __AP_SFL_H
  
  typedef struct RX_FLASH_INFO_Ttag
  {
    UINT32       ulPageSize;       /*!< Size of a page           */
    UINT32       ulPagesPerSector; /*!< Pages per sector         */
    UINT32       ulNumSectors;     /*!< Total number of sectors  */
    UINT8        bAddressMode;     /*!< Addressing mode of flash */
  } RX_FLASH_INFO_T;

  /*
  ******************************************************************************
  *   Size of one Serial FLASH Control Block a Task has to allocate memory for
  ******************************************************************************
  */ 
  #define DRV_SERFLASH_SIZE (152)

  /*
  ************************************************************
  *   Function Prototypes
  ************************************************************
  */
    
  RX_FATAL FAR    DrvSFlsInit                 (const FAR void FAR*                pvCfg,
                                               UINT                               uNum); 

  RX_RESULT FAR   Drv_SflCreateFlash          (RX_HANDLE                          hFlash,
                                               const RX_SERIALFLASH_SET_T FAR*    ptCfg); 

  RX_RESULT FAR   Drv_SflIdentifyFlash        (const STRING FAR*                  pszIdn,
                                               UINT                               uInst,
                                               RX_HANDLE FAR*                     phFlash); 

  RX_RESULT       Drv_SflInitializeFlash      (RX_HANDLE                          hFlash); 

  RX_RESULT       Drv_SflWriteFlash           (RX_HANDLE                          hFlash,
                                               UINT32                             ulOffset,
                                               const UINT8 HUGE*                  pabSrc,
                                               UINT32                             ulNum);

  RX_RESULT       Drv_SflReadFlash            (RX_HANDLE                          hFlash,
                                               UINT32                             ulOffs,
                                               UINT8 HUGE*                        pabDest,
                                               UINT32                             ulNum);

  RX_RESULT       Drv_SflEraseFlash           (RX_HANDLE                          hFlash,
                                               UINT32                             ulStartAddr,
                                               UINT32                             ulLen);

  RX_RESULT       Drv_SflEraseFlashPage       (RX_HANDLE                          hFlash,
                                               UINT32                             ulPage);

  RX_RESULT FAR   Drv_SflEraseFlashDevice     (RX_HANDLE                          hFlash);

  RX_RESULT       Drv_SflInfoFlash            (RX_HANDLE                          hFlash,
                                               RX_FLASH_INFO_T*                   ptInfo);

#endif  

#ifdef __cplusplus
}
#endif
